/**
  Copyright (c) 2014 Freescale Semiconductor
  
  \file       mc_cf.c
  \brief      This file contains a coverflow animation for a 800 pixel wide display
  \author     Freescale Semiconductor
  \author     IM, b06623
  \version    1.0
  
  * History:  26/Feb/2014 - Initial Version

* Copyright (c) 2014, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "..\HIL\Graphics.h"
#include "..\HIL\Display.h"
#include "..\HIL\Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "..\HIL\FontLibrary.h"

#include "tiny_ui.h"
#include "tiny_ui_util_nOS.h"
#include "tiny_ui_platform.h"

#include "math.h"

#include "mc_parameters.h"

#include ".\coverflow\MPLAYER.h"
//#include ".\coverflow\ALBUMS.h"
#include "ARIAL30.h"

// defines to configure the movie clip
#define CF_NUM_BUF 2
//#define CF_MIRROR
#define CF_CLEARCOLOR 0xFF000000
#define CF_YPOS	(0)
#define CF_FOVv (0.4f)
#define CF_XOFFSET (70)
#define CF_CENTER_OFFSET (50)

#ifndef CF_MAXIMG
#define CF_MAXIMG (14)
#endif

#define CF_WIDTH (208)
#define CF_HEIGHT (CF_WIDTH)
#define CF_SCALE (0.95f)
#define CF_SCALEI (1.0f - CF_SCALE)
#define DEG2RAD(x)	(0.01745329252 * (x))	

// function prototypes
void tui2go(Graphics_Object_t *dst, tiny_ui_buffer_t *src);

//todo: remove the typedef and stuff
typedef enum {
  VGU_NO_ERROR                                 = 0,
  VGU_BAD_HANDLE_ERROR                         = 0xF000,
  VGU_ILLEGAL_ARGUMENT_ERROR                   = 0xF001,
  VGU_OUT_OF_MEMORY_ERROR                      = 0xF002,
  VGU_PATH_CAPABILITY_ERROR                    = 0xF003,
  VGU_BAD_WARP_ERROR                           = 0xF004
} VGUErrorCode;

typedef float VGfloat;
typedef unsigned int RIuintptr;
void CF_mplayer(void);
uint8_t cfPrint(
	Graphics_Object_t*  target,
	char* string, Font_FontType* font,int16_t xoffset, 
        uint16_t yoffset, Font_JustifyType justify, uint16_t maxWidth, uint8_t count
);
VGUErrorCode  vguComputeWarpSquareToQuad(VGfloat dx0, VGfloat dy0, VGfloat dx1, VGfloat dy1, VGfloat dx2, VGfloat dy2, VGfloat dx3, VGfloat dy3, VGfloat * matrix);
VGUErrorCode  vguComputeWarpQuadToQuad(VGfloat dx0, VGfloat dy0, VGfloat dx1, VGfloat dy1, VGfloat dx2, VGfloat dy2, VGfloat dx3, VGfloat dy3, VGfloat sx0, VGfloat sy0, VGfloat sx1, VGfloat sy1, VGfloat sx2, VGfloat sy2, VGfloat sx3, VGfloat sy3, VGfloat * matrix);
VGUErrorCode  vguComputeWarpQuadToSquare(VGfloat sx0, VGfloat sy0, VGfloat sx1, VGfloat sy1, VGfloat sx2, VGfloat sy2, VGfloat sx3, VGfloat sy3, VGfloat * matrix);
void convertOVG2TinyUIMatrix(tiny_ui_matrix_t * dest, VGfloat * src);
void PPMatrixX(VGfloat H_angle, VGfloat width, VGfloat height, VGfloat FOV, VGfloat pivotX);
void CF_DrawAlbums(int image_idx, tiny_ui_buffer_t *Images, int max_images, float offset);
void tiny_ui_mult(tiny_ui_matrix_t * result, tiny_ui_matrix_t * A, tiny_ui_matrix_t * B);

// local variables
VGfloat	matrix2[9];
VGfloat matrix1[9];
tiny_ui_matrix_t matrix0;
VGfloat rD = 2.0f;  			// Reflection Distance, the space between the mirrored image and the original

extern tiny_ui_buffer_t ALBUMS[14];
//tiny_ui_buffer_t m_Images[CF_MAXIMG];
#define m_Images (ALBUMS)


tiny_ui_buffer_t frmBuf[CF_NUM_BUF];

tiny_ui_buffer_t barBuffer;
tiny_ui_buffer_t txtBuffer2;
    
int offset = 0;
int c_offset = 0;
int idx = 0;
int lock = 0;

int barFollow;


int currentBuffer = 0;
_Pragma("data_alignment=64")
mc_cf_parameters_t mc_cf_parameters;

void mc_cf(uint32_t CurrentFrame)
{
    uint32_t relative_fr;
    uint32_t i;
    tiny_ui_error_t error;
    tiny_ui_matrix_t matrix;
    static int toggle = 1;
    
    Graphics_Object_t tmp;
    
    if(mc_cf_properties.frameLatch == 0u)
    {
        mc_cf_properties.frameLatch = CurrentFrame;
    }
    relative_fr = CurrentFrame - mc_cf_properties.frameLatch;

    switch(relative_fr)
    {    
      case 0:
      break;
      case 1: 
        mc_cf_parameters.offset = 0;
        c_offset = 0;
        //reserve memory and initialize main layer
        for(i = 0; i < CF_NUM_BUF; ++i)
        {
          frmBuf[i].width	= 800;
          frmBuf[i].height	= 260;
          frmBuf[i].stride	= frmBuf[i].width*2;
          frmBuf[i].format	= TINY_UI_RGBA4444;//TINY_UI_RGB565;
          error = tiny_ui_allocate(&frmBuf[i]);
          if (error) while(1);
        }
        //initialize source images to point somewhere
        for(int i = 0; i<CF_MAXIMG; i++)
        {          
          /*
          m_Images[i].height = CF_HEIGHT;
          m_Images[i].width = CF_WIDTH;
          m_Images[i].stride = CF_WIDTH * 2;
          m_Images[i].format = TINY_UI_RGB565;
          m_Images[i].handle = NULL_PTR;
         

          m_Images[i].address = ALBUMS_GObjectArray[i]->address;
          //m_Images[i].address = testImg565_GObjectArray[0]->address;
          m_Images[i].memory = (void *)ALBUMS_GObjectArray[i]->address;
          //m_Images[i].memory = (void *)testImg565_GObjectArray[0]->address;
          //mc_cf_parameters.img_idx[i] = 255;
			*/
		}
        
        barBuffer.width	        = 408;
        barBuffer.height	= 24;
        barBuffer.stride	= barBuffer.width;
        barBuffer.format	= TINY_UI_A8;
        error = tiny_ui_allocate(&barBuffer);
        if (error) while(1);        
        tiny_ui_clear(&barBuffer, NULL, 0x00000000);
        
        
        txtBuffer2.width	= 480;
        txtBuffer2.height	= 30;
        txtBuffer2.stride	= txtBuffer2.width;
        txtBuffer2.format	= TINY_UI_A8;
        error = tiny_ui_allocate(&txtBuffer2);
        if (error) while(1);        
        tiny_ui_clear(&txtBuffer2, NULL, 0x00000000);
        mc_cf_parameters.print = 0;
        
        
        
        barFollow = 0;
        mc_cf_parameters.status = 0;
        mc_cf_parameters.bar = 0;
        
         // display BAR outer layer
        Display_InitLayer(COVERFLOW_BARTBOT,MPLAYER_GObjectArray[0],0xDC,0x160); 
        DCU_LayerAlphaCfg(COVERFLOW_BARTBOT) = 2;
        DCU_LayerChromaCfg(COVERFLOW_BARTBOT) = 1;
        Display_FGColor(COVERFLOW_BARTBOT) = 0xFFFFFFFF;
        Display_BGColor(COVERFLOW_BARTBOT) = 0x0; 
        
        tui2go(&tmp, &barBuffer);  
        Display_InitLayer(COVERFLOW_BARGROW,&tmp,0xE2,0x167); 
        DCU_LayerAlphaCfg(COVERFLOW_BARGROW) = 2;
        DCU_LayerChromaCfg(COVERFLOW_BARGROW) = 1;
        Display_FGColor(COVERFLOW_BARGROW) = 0x1aB3ff;
        Display_BGColor(COVERFLOW_BARGROW) = 0x0; 
        
         // display BAR outer layer
        Display_InitLayer(COVERFLOW_PLAY,MPLAYER_GObjectArray[4],179,350); 
        DCU_LayerAlphaCfg(COVERFLOW_PLAY) = 2;
        DCU_LayerChromaCfg(COVERFLOW_PLAY) = 1;
        Display_FGColor(COVERFLOW_PLAY) = 0xFFFFFFFF;
        Display_BGColor(COVERFLOW_PLAY) = 0x0;         
        
         // text
        tui2go(&tmp, &txtBuffer2); 
        Display_InitLayer(COVERFLOW_TXT,&tmp,160,320); 
        DCU_LayerAlphaCfg(COVERFLOW_TXT) = 2;
        DCU_LayerChromaCfg(COVERFLOW_TXT) = 1;
        Display_FGColor(COVERFLOW_TXT) = 0xFFFFFFFF;
        Display_BGColor(COVERFLOW_TXT) = 0x0; 
        
        //tiny_ui_clear(&frmBuf[currentBuffer], NULL, 0xFFFF0000);
        //Display_InitLayer(COVERFLOW_CENTER,&tmp,0,117);          
        //vguComputeWarpQuadToQuad(VGfloat dx0, VGfloat dy0, VGfloat dx1, VGfloat dy1, VGfloat dx2, VGfloat dy2, VGfloat dx3, VGfloat dy3, 0, 0, 0, 260, 800, 260, 800, 0, matrix1);
      break;
        
      default:
          CF_mplayer();
          if(mc_cf_parameters.print == 1)
          {
            tiny_ui_clear(&txtBuffer2, NULL, 0x00000000);
            tui2go(&tmp, &txtBuffer2); 
            cfPrint(&tmp,mc_cf_parameters.str,(Font_FontType*)&ARIAL30_Font,0, 0, FONT_CENTER, 480, 0); 
            mc_cf_parameters.print = 0;
            mc_global_parameters.mmSource = 5; // Jukebox icon
            mc_tabs_parameters.mmText = (uint8_t*)&mc_cf_parameters.str[0]; // string addr. 
            mc_tabs_parameters.mmTextUpdate = 1;        //print the text in mc_tabs
          }
          if(toggle==0)
          {
            int error;
            offset = mc_cf_parameters.offset;
            error = (offset - c_offset)/10;
            
            
            
            
            if(error == 0)
            {
                    if(offset > c_offset)
                            error = 1;
                    if(offset < c_offset)
                            error = -1;
            }
            else if(abs(error) < 4){ 
                    if(offset > c_offset)
                            error++;
                    if(offset < c_offset)
                            error--;
            }
              
            c_offset += error;	
            
            /*            
            if(c_offset>offset)
                    c_offset -= 4;
            if(c_offset<offset)
                    c_offset += 4;


            if(c_offset == offset && lock)
            {
                    idx += CF_MAXIMG + (offset>0?-1:1);
                    idx = idx%CF_MAXIMG;
                    c_offset = 0;
                    offset = 0;
                    lock = 0;
            }
            */
            CF_DrawAlbums(idx,m_Images,CF_MAXIMG,c_offset/100.0f);
            tui2go(&tmp, &frmBuf[currentBuffer]);
            Display_InitLayer(COVERFLOW_CENTER,&tmp,0,117); 
            currentBuffer = (currentBuffer + 1)%CF_NUM_BUF;        
            toggle = 1;
          }
          else
          {
            /*
            for(int i = 0; i<CF_MAXIMG; i++)
            {          
              if(mc_cf_parameters.img_idx[i] < CF_MAXIMG){
                m_Images[i].memory = (void *)(&mc_cf_parameters.bitmaps[mc_cf_parameters.img_idx[i]*200*200*2]);
                m_Images[i].address = (uint32_t)(&mc_cf_parameters.bitmaps[mc_cf_parameters.img_idx[i]*200*200*2]);                
              }
              else
              {
                m_Images[i].memory = (void *)testImg565_GObjectArray[0]->address;
                m_Images[i].address = testImg565_GObjectArray[0]->address;
              }
            }
            */            
            CF_DrawAlbums(idx,m_Images,CF_MAXIMG,c_offset/100.0f);
            toggle = 0;
          }
      break;
    }
    
}

void mc_cf_Dispose()
{
  //tiny_ui_buffer_t m_Images[CF_MAXIMG];
  //tiny_ui_buffer_t frmBuf[CF_NUM_BUF];
  //tiny_ui_buffer_t barBuffer;
  //tiny_ui_buffer_t txtBuffer2;
  //de-allocate all tinyUI structures
  tiny_ui_free(&barBuffer);
  tiny_ui_free(&txtBuffer2);
  for(int i =0; i<CF_NUM_BUF; i++)
  {
    tiny_ui_free(&frmBuf[i]);
  }
  
  DCU_LayerDisable(COVERFLOW_CENTER);
  DCU_LayerDisable(COVERFLOW_BARTBOT);
  DCU_LayerDisable(COVERFLOW_BARGROW);
  DCU_LayerDisable(COVERFLOW_PLAY);
  DCU_LayerDisable(COVERFLOW_TXT);
	
}

void mc_cf_Refresh()
{

}


void CF_mplayer(void)
{
  uint8_t *u8src;
  uint8_t *u8dst;
  uint16_t width;
  uint16_t width2;

 
  //depending on the percentage value, display the bar
  //values go actually from zero to 400
  //barvalue = (mc_cf_parameters.bar)*400;
  if(mc_cf_parameters.bar > 400)    mc_cf_parameters.bar = 400;
  if(mc_cf_parameters.bar < 0)    mc_cf_parameters.bar = 0; 
  //reinit
  if(barFollow>mc_cf_parameters.bar) 
  {
    tiny_ui_clear(&barBuffer, NULL, 0x00000000);
    barFollow = 0;
  }
  //grow
  width = MPLAYER_GObjectArray[3]->width;
  width2 = barBuffer.width;
  if(barFollow<mc_cf_parameters.bar)
  {
    if(barFollow<7)
    {
      //copy columns left
      u8src = (uint8_t *)(MPLAYER_GObjectArray[3]->address + (barFollow-1));
      u8dst = (uint8_t *)(barBuffer.address+ (barFollow-1));     
      for(int j =0; j<MPLAYER_GObjectArray[3]->height; j++)
      {
       *u8dst = *u8src;
       u8src += width;
       u8dst += width2; 
      }
      //copy columns right
      for(int k = (7-barFollow); k<7; k++)
      {
        u8src = (uint8_t *)(MPLAYER_GObjectArray[3]->address+(6+k));
        u8dst = (uint8_t *)(barBuffer.address+barFollow+k-7+barFollow);
        
        for(int j =0; j<MPLAYER_GObjectArray[3]->height; j++)
        {
         *u8dst = *u8src;
         u8src += width;
         u8dst += width2; 
        }
      }
    }
    else
    {
      //copy columns right
      for(int k = 0; k<7; k++)
      {
        u8src = (uint8_t *)(MPLAYER_GObjectArray[3]->address+(6+k));
        u8dst = (uint8_t *)(barBuffer.address+(barFollow-1)+k);
        
        for(int j =0; j<MPLAYER_GObjectArray[3]->height; j++)
        {
         *u8dst = *u8src;
         u8src += width;
         u8dst += width2; 
        }
      }
      
    }
    barFollow++;
  }
  

  if(mc_cf_parameters.status == 0) Display_InitLayer(COVERFLOW_PLAY,MPLAYER_GObjectArray[4],179,350); 
  else Display_InitLayer(COVERFLOW_PLAY,MPLAYER_GObjectArray[5],179,350); 
  

  
}

// Helper Functions
void tui2go(Graphics_Object_t *dst, tiny_ui_buffer_t *src)
{
    dst->address = src->address;
    dst->width = src->width;
    dst->height = src->height;
    dst->CLUT = 0;
    dst->CLUTsize = 0;
    dst->CLUTOffset = 0;
    switch(src->format)
    {
    case TINY_UI_RGBA8888:
      dst->BPP = GRAPHICS_32BPP;
      break;
    case TINY_UI_RGB565:
      dst->BPP = GRAPHICS_565RGB;
      break;
    case TINY_UI_RGBA4444:
      dst->BPP = GRAPHICS_4444ARGB;
      break; 
    case TINY_UI_A8:
      dst->BPP = GRAPHICS_T8BPP;
      break;       
    default:
      dst->BPP = GRAPHICS_8BPP;
      break;
    }
    dst->initialAlpha = 255;
    dst->initialChromaMax = 0;
    dst->initialChromaMin = 0;
    dst->coding = 0;
    dst->x = 0;
    dst->y = 0;  
    dst->ext = 0;     
}

tiny_ui_matrix_t matrixC;
tiny_ui_matrix_t matrixL;
tiny_ui_matrix_t matrixR;
tiny_ui_blend_t testt = TINY_UI_BLEND_SRC_OVER;
void CF_DrawCenter(int image_idx, tiny_ui_buffer_t *Images, int max_images, float offset)
{
    float tmp;
    // center
    tiny_ui_Identity(&matrix0);
    tiny_ui_Translate(400.0f - (0.5f*CF_WIDTH)*(1.0f-fabs(offset*CF_SCALEI)) + (offset*(CF_XOFFSET+CF_CENTER_OFFSET)),CF_YPOS - CF_SCALEI*0.5f*CF_HEIGHT*(1.0f - fabs(offset)),&matrix0);
    tmp = offset;
    if(offset>0.54f)
            tmp = 0.54f;
    else if(offset<-0.54f)
            tmp = -0.54f;
    tiny_ui_Scale(1.0f-fabs(offset*CF_SCALEI),1.0f-fabs(offset*CF_SCALEI),&matrix0);
    PPMatrixX(DEG2RAD(0 - (50*tmp/0.54f)),  CF_WIDTH, CF_HEIGHT, CF_FOVv, (offset>0.0f)?CF_WIDTH:0.0f);
    tiny_ui_blit(&frmBuf[currentBuffer], &(Images[image_idx%max_images]), &matrix0, TINY_UI_BLEND_SRC_OVER, 0);
#ifdef CF_MIRROR
    {
      tiny_ui_buffer_t mirror = Images[image_idx%max_images];
      mirror.height = 60;
      mirror.address = mirror.address + (CF_HEIGHT - mirror.height)*mirror.width*4;
      mirror.memory = (void*)mirror.address;
      tiny_ui_Translate(0,mirror.height+CF_HEIGHT,&matrix0);
      tiny_ui_Scale(1,-1,&matrix0);
      tiny_ui_blit(&frmBuf[currentBuffer], &mirror, &matrix0, TINY_UI_BLEND_SRC_OVER, 0);
      tiny_ui_blit(&frmBuf[currentBuffer], &m_mask, &matrix0, testt, CLEARCOLOR);
    }
#endif    
}

void CF_DrawCenterLeft(int image_idx, tiny_ui_buffer_t *Images, int max_images, float offset)
{
    float tmp;
    tmp = fabs(offset);
    if(tmp<0.4f)
            tmp = 0.0f;
    else
            tmp = (tmp - 0.4f)/0.6f;
    // center left
    tiny_ui_Identity(&matrix0);
    tiny_ui_Translate(400.0f - (0.5f*CF_WIDTH)*(CF_SCALE + offset*((offset>0.0f)?CF_SCALEI:0)) - CF_XOFFSET - CF_CENTER_OFFSET + (offset*(CF_XOFFSET+((offset>0.0f)?CF_CENTER_OFFSET:0))),CF_YPOS - CF_SCALEI*0.5f*CF_HEIGHT*((offset>0.0f)?offset:0),&matrix0);
    tiny_ui_Scale(CF_SCALE + offset*((offset>0.0f)?CF_SCALEI:0),CF_SCALE + offset*((offset>0.0f)?CF_SCALEI:0),&matrix0);
    PPMatrixX(DEG2RAD(50 - (((offset>0.0f)?50:0)*tmp)),  CF_WIDTH, CF_HEIGHT, CF_FOVv, 0.0f);
    tiny_ui_blit(&frmBuf[currentBuffer], &(Images[(image_idx-1)%max_images]), &matrix0, TINY_UI_BLEND_SRC_OVER, 0);
#ifdef CF_MIRROR
    {
      tiny_ui_buffer_t mirror = Images[(image_idx-1)%max_images];
      mirror.height = 60;
      mirror.address = mirror.address + (CF_HEIGHT - mirror.height)*mirror.width*4;
      mirror.memory = (void*)mirror.address;
      tiny_ui_Translate(0,mirror.height+CF_HEIGHT,&matrix0);
      tiny_ui_Scale(1,-1,&matrix0);
      tiny_ui_blit(&frmBuf[currentBuffer], &mirror, &matrix0, TINY_UI_BLEND_SRC_OVER, 0);
      tiny_ui_blit(&frmBuf[currentBuffer], &m_mask, &matrix0, testt, CLEARCOLOR);
    }
#endif     
}

void CF_DrawCenterRight(int image_idx, tiny_ui_buffer_t *Images, int max_images, float offset)
{

    float tmp;
    tmp = fabs(offset);
    if(tmp<0.4f)
            tmp = 0.0f;
    else
            tmp = (tmp - 0.4f)/0.6f;
    // center right
    tiny_ui_Identity(&matrix0);
    tiny_ui_Translate(400.0f - (0.5f*CF_WIDTH)*(CF_SCALE - offset*((offset<0.0f)?CF_SCALEI:0)) + CF_XOFFSET + CF_CENTER_OFFSET + (offset*(CF_XOFFSET+((offset<0.0f)?CF_CENTER_OFFSET:0))),CF_YPOS + CF_SCALEI*0.5f*CF_HEIGHT*((offset<0.0f)?offset:0),&matrix0);				
    tiny_ui_Scale(CF_SCALE - offset*((offset<0.0f)?CF_SCALEI:0),CF_SCALE - offset*((offset<0.0f)?CF_SCALEI:0),&matrix0);
    PPMatrixX(DEG2RAD(-50 + (((offset<0.0f)?50:0)*tmp)),  CF_WIDTH, CF_HEIGHT, CF_FOVv, CF_WIDTH);
    tiny_ui_blit(&frmBuf[currentBuffer], &(Images[(image_idx+1)%max_images]), &matrix0, TINY_UI_BLEND_SRC_OVER, 0);
#ifdef CF_MIRROR
    {
      tiny_ui_buffer_t mirror = Images[(image_idx+1)%max_images];
      mirror.height = 60;
      mirror.address = mirror.address + (CF_HEIGHT - mirror.height)*mirror.width*4;
      mirror.memory = (void*)mirror.address;
      tiny_ui_Translate(0,mirror.height+CF_HEIGHT,&matrix0);
      tiny_ui_Scale(1,-1,&matrix0);
      tiny_ui_blit(&frmBuf[currentBuffer], &mirror, &matrix0, TINY_UI_BLEND_SRC_OVER, 0);
      tiny_ui_blit(&frmBuf[currentBuffer], &m_mask, &matrix0, testt, CLEARCOLOR);
    }
#endif     
}

void CF_DrawLeft(int image_idx, tiny_ui_buffer_t *Images, int max_images, float offset, int position)
{
    tiny_ui_buffer_t tmpBuffer;
    tmpBuffer = frmBuf[currentBuffer];     
    tiny_ui_Identity(&matrix0);	
    tiny_ui_Translate((400.0f - 0.5f*CF_WIDTH*(CF_SCALE) -position*CF_XOFFSET -CF_CENTER_OFFSET + (offset*CF_XOFFSET)),(CF_YPOS),&matrix0);	
    if(position==2) tmpBuffer.width = 120 + matrix0.m[0][2];
    else tmpBuffer.width = 70 + matrix0.m[0][2];
    if(tmpBuffer.width>0){
      tiny_ui_Scale(CF_SCALE,CF_SCALE,&matrix0);
      PPMatrixX(DEG2RAD(50),  CF_WIDTH, CF_HEIGHT, CF_FOVv, 0.0f);	
      tiny_ui_blit(&tmpBuffer, &(Images[(image_idx-position)%max_images]), &matrix0, TINY_UI_BLEND_NONE, 0);
#ifdef CF_MIRROR
      {
        tiny_ui_buffer_t mirror = Images[(image_idx-position)%max_images];
        mirror.height = 60;
        mirror.address = mirror.address + (CF_HEIGHT - mirror.height)*mirror.width*4;
        mirror.memory = (void*)mirror.address;
        tiny_ui_Translate(0,mirror.height+CF_HEIGHT,&matrix0);
        tiny_ui_Scale(1,-1,&matrix0);
        tiny_ui_blit(&tmpBuffer, &mirror, &matrix0, TINY_UI_BLEND_SRC_OVER, 0);
        tiny_ui_blit(&tmpBuffer, &m_mask, &matrix0, testt, CLEARCOLOR);
      }
#endif       
    }    
}

void CF_DrawRight(int image_idx, tiny_ui_buffer_t *Images, int max_images, float offset, int position)
{
    tiny_ui_buffer_t tmpBuffer;
    tmpBuffer = frmBuf[currentBuffer];         
    tiny_ui_Identity(&matrix0);		
    tiny_ui_Translate((400.0f - 0.5f*CF_WIDTH*(CF_SCALE) +position*CF_XOFFSET +CF_CENTER_OFFSET + (offset*CF_XOFFSET)),(CF_YPOS),&matrix0);
    //tmpBuffer.width = 70 + matrix0.m[3][0];
    tiny_ui_Scale(CF_SCALE,CF_SCALE,&matrix0);
    PPMatrixX(DEG2RAD(-50),CF_WIDTH, CF_HEIGHT, CF_FOVv, CF_WIDTH);	
    tiny_ui_blit(&tmpBuffer, &(Images[(image_idx+position)%max_images]), &matrix0, TINY_UI_BLEND_NONE, 0);
#ifdef CF_MIRROR
    {
      tiny_ui_buffer_t mirror = Images[(image_idx+position)%max_images];
      mirror.height = 60;
      mirror.address = mirror.address + (CF_HEIGHT - mirror.height)*mirror.width*4;
      mirror.memory = (void*)mirror.address;
      tiny_ui_Translate(0,mirror.height+CF_HEIGHT,&matrix0);
      tiny_ui_Scale(1,-1,&matrix0);
      tiny_ui_blit(&tmpBuffer, &mirror, &matrix0, TINY_UI_BLEND_SRC_OVER, 0);
      tiny_ui_blit(&tmpBuffer, &m_mask, &matrix0, testt, CLEARCOLOR);
    }  
#endif     
}


void CF_DrawAlbums(int image_idx, tiny_ui_buffer_t *Images, int max_images, float ccoffset)
{
  static int toggle = 1;

  float offset = 0.0f;
  int coffset;
  int tmp;  

  coffset = ccoffset*100;
  
  tmp = coffset/100;
  offset = (coffset-(tmp*100))/100.0f;
  if(offset<0)
  {
          offset += 1.0f;
          image_idx++;
  } 
  
  image_idx -= tmp;		
  // to avoid negative number mod operation
  // consistent results on mod operation	
  if(image_idx<0)
  {
          tmp = image_idx/max_images; 
          image_idx -= (tmp*max_images);
          //offset += 1.0f;	
  }	 
  image_idx += (2*max_images);  
  
  
/*  
  if(offset>1.0f)
          offset = 1.0f;
  if(offset<-1.0f)
          offset = -1.0f;
  // to avoid negative number mod operation
  // consistent results on mod operation
  image_idx += max_images; 
*/  

  if(toggle)
  {
    toggle = 0;
    // draw album on the empty space depending offset
    
    tiny_ui_clear(&frmBuf[currentBuffer], NULL, CF_CLEARCOLOR);
    
    
    if(offset>0.0f) CF_DrawLeft(image_idx, Images, max_images, offset, 5);
    else    CF_DrawRight(image_idx, Images, max_images, offset, 5);
    
    CF_DrawLeft(image_idx, Images, max_images,  offset, 4);
    CF_DrawRight(image_idx, Images, max_images, offset, 4);        
    
    CF_DrawLeft(image_idx, Images, max_images,  offset, 3);
    CF_DrawRight(image_idx, Images, max_images, offset, 3);
    
    CF_DrawLeft(image_idx, Images, max_images,  offset, 2);
    CF_DrawRight(image_idx, Images, max_images, offset, 2);
    
  }
  {
    toggle = 1;
    if(offset>0.4f)
    {
          CF_DrawCenterRight(image_idx, Images, max_images, offset);
          CF_DrawCenter(image_idx, Images, max_images, offset);
          CF_DrawCenterLeft(image_idx, Images, max_images, offset);
    }
    else if(offset<-0.4f)
    {
          CF_DrawCenterLeft(image_idx, Images, max_images, offset);
          CF_DrawCenter(image_idx, Images, max_images, offset);
          CF_DrawCenterRight(image_idx, Images, max_images, offset);
    }
    else
    {
          CF_DrawCenterLeft(image_idx, Images, max_images, offset);
          CF_DrawCenterRight(image_idx, Images, max_images, offset);
          CF_DrawCenter(image_idx, Images, max_images, offset);
    }
  }
  
        
}

void PPMatrixX(VGfloat H_angle, VGfloat width, VGfloat height, VGfloat FOV, VGfloat pivotX)
{
	VGfloat matrix1[9];
        tiny_ui_matrix_t matrix4,matrix3;
	
	VGfloat Xw;
	VGfloat Yo;
	VGfloat Rx;
	VGfloat Po,Pon;
	

	Xw = cos(H_angle) * width;  // transformed width
	Rx = width - Xw;			// width delta
	Yo = sin(H_angle) * (height/2) * FOV;	// height reduction due to horizontal angle
	Po = pivotX/width;						// ratio of reduction affected by X pivot point offset
	Pon= 1.0f - Po;							// inverse ..

//Compute the matrix for the main image	
	vguComputeWarpQuadToQuad(	
			(Po * Rx), height + (Po * Yo) + rD, 
			(Po * Rx) + Xw, height - (Pon * Yo) + rD, 
			(Po * Rx) + Xw, (Pon * Yo) + rD, 
			(Po * Rx), (Po * -Yo)  + rD, 

			0, height, 
			width, height, 
			width, 0,  
			0, 0,
			matrix1
	);
//Compute the matrix for the reflection
	vguComputeWarpQuadToQuad(	
			(Po * Rx), (3*(Po * -Yo)) - height - rD,
			(Po * Rx) + Xw, (3*(Pon * Yo)) - rD - height,
			(Po * Rx) + Xw, (Pon * Yo) - rD,
			(Po * Rx), (Po * -Yo) -rD,

			0, height, 
			width, height, 
			width, 0,  
			0, 0,
			matrix2 
	);
//Multiply the main image matrix, the reflection matrix is saved for later.
	//vgMultMatrix(matrix1);
        convertOVG2TinyUIMatrix(&matrix4,matrix1);
        tiny_ui_mult(&matrix3, &matrix0, &matrix4);
        
        matrix0.m[0][0] = matrix3.m[0][0]; 
        matrix0.m[0][1] = matrix3.m[0][1]; 
        matrix0.m[0][2] = matrix3.m[0][2]; 
        
        matrix0.m[1][0] = matrix3.m[1][0]; 
        matrix0.m[1][1] = matrix3.m[1][1]; 
        matrix0.m[1][2] = matrix3.m[1][2]; 
        
        matrix0.m[2][0] = matrix3.m[2][0]; 
        matrix0.m[2][1] = matrix3.m[2][1]; 
        matrix0.m[2][2] = matrix3.m[2][2]; 
		
}

void PPMatrixY(VGfloat V_angle, VGfloat width, VGfloat height, VGfloat FOV, VGfloat pivotY)
{
	VGfloat matrix1[9];
        tiny_ui_matrix_t matrix4,matrix3;
	
	VGfloat Xw;
	VGfloat Yo;
	VGfloat Rx;
	VGfloat Po,Pon;
	
	Xw = cos(V_angle) * height;
	Rx = height - Xw;
	Yo = sin(V_angle) * (width/2) * FOV;
	Po = pivotY/height;
	Pon= 1.0f - Po;
	
	vguComputeWarpQuadToQuad(	
			//(Po * Rx), height + (Po * Yo) + rD, 
			(Pon * Yo) , height - (Pon * Rx) + rD,  
			width - (Pon * Yo),height - (Pon * Rx) + rD, 
			width + (Po * Yo),(Po * Rx) + rD,  
			(Po * -Yo), (Po * Rx) + rD,  

			0, height, 
			width, height, 
			width, 0,  
			0, 0,
			//0, height, 
			matrix1
	);

	//vgMultMatrix(matrix1);
        convertOVG2TinyUIMatrix(&matrix4,matrix1);
        tiny_ui_mult(&matrix3, &matrix0, &matrix4);
        
        matrix0.m[0][0] = matrix3.m[0][0]; 
        matrix0.m[0][1] = matrix3.m[0][1]; 
        matrix0.m[0][2] = matrix3.m[0][2]; 
        
        matrix0.m[1][0] = matrix3.m[1][0]; 
        matrix0.m[1][1] = matrix3.m[1][1]; 
        matrix0.m[1][2] = matrix3.m[1][2]; 
        
        matrix0.m[2][0] = matrix3.m[2][0]; 
        matrix0.m[2][1] = matrix3.m[2][1]; 
        matrix0.m[2][2] = matrix3.m[2][2]; 		
}

// Warping functions taken from OpenVG
// to be used later
void convertOVG2TinyUIMatrix(tiny_ui_matrix_t * dest, VGfloat * src)
{

	dest->m[0][0] = src[0]; 
	dest->m[0][1] = src[3]; 
	dest->m[0][2] = src[6]; 
	
	dest->m[1][0] = src[1]; 
	dest->m[1][1] = src[4]; 
	dest->m[1][2] = src[7]; 

	dest->m[2][0] = src[2]; 
	dest->m[2][1] = src[5]; 
	dest->m[2][2] = src[8]; 	
  
}


VGUErrorCode  vguComputeWarpSquareToQuad(VGfloat dx0, VGfloat dy0, VGfloat dx1, VGfloat dy1, VGfloat dx2, VGfloat dy2, VGfloat dx3, VGfloat dy3, VGfloat * matrix)
{
	if(!matrix || ((RIuintptr)matrix) & 3)
		return VGU_ILLEGAL_ARGUMENT_ERROR;

	//from Heckbert:Fundamentals of Texture Mapping and Image Warping
	//Note that his mapping of vertices is different from OpenVG's
	//(0,0) => (dx0,dy0)
	//(1,0) => (dx1,dy1)
	//(0,1) => (dx2,dy2)
	//(1,1) => (dx3,dy3)

	VGfloat diffx1 = dx1 - dx3;
	VGfloat diffy1 = dy1 - dy3;
	VGfloat diffx2 = dx2 - dx3;
	VGfloat diffy2 = dy2 - dy3;

	VGfloat det = diffx1*diffy2 - diffx2*diffy1;
	if(det == 0.0f)
		return VGU_BAD_WARP_ERROR;

	VGfloat sumx = dx0 - dx1 + dx3 - dx2;
	VGfloat sumy = dy0 - dy1 + dy3 - dy2;

	if(sumx == 0.0f && sumy == 0.0f)
	{	//affine mapping
		matrix[0] = dx1 - dx0;
		matrix[1] = dy1 - dy0;
		matrix[2] = 0.0f;
		matrix[3] = dx3 - dx1;
		matrix[4] = dy3 - dy1;
		matrix[5] = 0.0f;
		matrix[6] = dx0;
		matrix[7] = dy0;
		matrix[8] = 1.0f;
		return VGU_NO_ERROR;
	}

	VGfloat oodet = 1.0f / det;
	VGfloat g = (sumx*diffy2 - diffx2*sumy) * oodet;
	VGfloat h = (diffx1*sumy - sumx*diffy1) * oodet;

	matrix[0] = dx1-dx0+g*dx1;
	matrix[1] = dy1-dy0+g*dy1;
	matrix[2] = g;
	matrix[3] = dx2-dx0+h*dx2;
	matrix[4] = dy2-dy0+h*dy2;
	matrix[5] = h;
	matrix[6] = dx0;
	matrix[7] = dy0;
	matrix[8] = 1.0f;
	return VGU_NO_ERROR;
}


VGUErrorCode  vguComputeWarpQuadToSquare(VGfloat sx0, VGfloat sy0, VGfloat sx1, VGfloat sy1, VGfloat sx2, VGfloat sy2, VGfloat sx3, VGfloat sy3, VGfloat * matrix)
{
	if(!matrix || ((RIuintptr)matrix) & 3)
		return VGU_ILLEGAL_ARGUMENT_ERROR;

	VGfloat mat[9];
	VGUErrorCode ret = vguComputeWarpSquareToQuad(sx0, sy0, sx1, sy1, sx2, sy2, sx3, sy3, mat);
	if(ret == VGU_BAD_WARP_ERROR)
		return VGU_BAD_WARP_ERROR;
        
        VGfloat det;
        // det(A) = a(ei-fh)-b(id-fg)+c(dh-eg)
        det = mat[0]*(mat[4]*mat[8] -  mat[7]*mat[5]) - mat[3]*(mat[8]*mat[1] -  mat[7]*mat[2]) + mat[6]*(mat[1]*mat[5] -  mat[4]*mat[2]);
        if(det == 0.0f)
          return VGU_BAD_WARP_ERROR;

        //A = (ei-fh)   D = -(bi-ch)  G = (bf-ce)  
        //B = -(di-fg)  E = (ai-cg)   H = -(af-cd) 
        //C = (dh-eg)   F = -(ah-bg)  I = (ae-bd)  

        matrix[0] = (mat[4]*mat[8] -  mat[7]*mat[5])/det;
        matrix[1] = -(mat[8]*mat[1] -  mat[7]*mat[2])/det;
        matrix[2] = (mat[1]*mat[5] -  mat[4]*mat[2])/det;
        matrix[3] = -(mat[3]*mat[8] -  mat[6]*mat[5])/det;
        matrix[4] = (mat[0]*mat[8] -  mat[6]*mat[2])/det;
        matrix[5] = -(mat[0]*mat[5] -  mat[3]*mat[2])/det;
        matrix[6] = (mat[3]*mat[7] -  mat[6]*mat[4])/det;
        matrix[7] = -(mat[0]*mat[7] -  mat[6]*mat[1])/det;
        matrix[8] = (mat[0]*mat[4] -  mat[3]*mat[1])/det;
        

	return VGU_NO_ERROR;
}



VGUErrorCode  vguComputeWarpQuadToQuad(VGfloat dx0, VGfloat dy0, VGfloat dx1, VGfloat dy1, VGfloat dx2, VGfloat dy2, VGfloat dx3, VGfloat dy3, VGfloat sx0, VGfloat sy0, VGfloat sx1, VGfloat sy1, VGfloat sx2, VGfloat sy2, VGfloat sx3, VGfloat sy3, VGfloat * matrix)
{
	if(!matrix || ((RIuintptr)matrix) & 3)
		return VGU_ILLEGAL_ARGUMENT_ERROR;

	VGfloat qtos[9];
	VGUErrorCode ret1 = vguComputeWarpQuadToSquare(sx0, sy0, sx1, sy1, sx2, sy2, sx3, sy3, qtos);
	if(ret1 == VGU_BAD_WARP_ERROR)
		return VGU_BAD_WARP_ERROR;

	VGfloat stoq[9];
	VGUErrorCode ret2 = vguComputeWarpSquareToQuad(dx0, dy0, dx1, dy1, dx2, dy2, dx3, dy3, stoq);
	if(ret2 == VGU_BAD_WARP_ERROR)
		return VGU_BAD_WARP_ERROR;

        matrix[0] = stoq[0]*qtos[0] + stoq[3]*qtos[1] + stoq[6]*qtos[2];
	matrix[1] = stoq[1]*qtos[0] + stoq[4]*qtos[1] + stoq[7]*qtos[2];
	matrix[2] = stoq[2]*qtos[0] + stoq[5]*qtos[1] + stoq[8]*qtos[2];
	matrix[3] = stoq[0]*qtos[3] + stoq[3]*qtos[4] + stoq[6]*qtos[5];
	matrix[4] = stoq[1]*qtos[3] + stoq[4]*qtos[4] + stoq[7]*qtos[5];
	matrix[5] = stoq[2]*qtos[3] + stoq[5]*qtos[4] + stoq[8]*qtos[5];
	matrix[6] = stoq[0]*qtos[6] + stoq[3]*qtos[7] + stoq[6]*qtos[8];
	matrix[7] = stoq[1]*qtos[6] + stoq[4]*qtos[7] + stoq[7]*qtos[8];
	matrix[8] = stoq[2]*qtos[6] + stoq[5]*qtos[7] + stoq[8]*qtos[8];
        
	return VGU_NO_ERROR;
}

void tiny_ui_mult(tiny_ui_matrix_t * result, tiny_ui_matrix_t * A, tiny_ui_matrix_t * B)
{
      result->m[0][0] = A->m[0][0]*B->m[0][0] + A->m[0][1]*B->m[1][0] + A->m[0][2]*B->m[2][0];
      result->m[0][1] = A->m[0][0]*B->m[0][1] + A->m[0][1]*B->m[1][1] + A->m[0][2]*B->m[2][1];
      result->m[0][2] = A->m[0][0]*B->m[0][2] + A->m[0][1]*B->m[1][2] + A->m[0][2]*B->m[2][2];
      
      result->m[1][0] = A->m[1][0]*B->m[0][0] + A->m[1][1]*B->m[1][0] + A->m[1][2]*B->m[2][0];
      result->m[1][1] = A->m[1][0]*B->m[0][1] + A->m[1][1]*B->m[1][1] + A->m[1][2]*B->m[2][1];
      result->m[1][2] = A->m[1][0]*B->m[0][2] + A->m[1][1]*B->m[1][2] + A->m[1][2]*B->m[2][2];

      result->m[2][0] = A->m[2][0]*B->m[0][0] + A->m[2][1]*B->m[1][0] + A->m[2][2]*B->m[2][0];
      result->m[2][1] = A->m[2][0]*B->m[0][1] + A->m[2][1]*B->m[1][1] + A->m[2][2]*B->m[2][1];
      result->m[2][2] = A->m[2][0]*B->m[0][2] + A->m[2][1]*B->m[1][2] + A->m[2][2]*B->m[2][2];      
      
}




int cfPrintwaitvar=1;
void cfPrintwait(void)
{
  cfPrintwaitvar = 0;    
}
uint8_t cfPrint(
	Graphics_Object_t*  target,
	char* string, Font_FontType* font,int16_t xoffset, 
        uint16_t yoffset, Font_JustifyType justify, uint16_t maxWidth, uint8_t count
)
{
uint8_t dmachnl;
uint32_t i, length;

        // if count is 0 this is a NULL terminated string and we need to calc the count 
        if (count == 0){
          for(i=0;i<100;i++) 
          {
            if(string[i] == 0) {count = i; break;}
          }
          if(i==100)    return 1;  // there was no NULL termination
        }
        // in case we want to limit the output width, if = 0 we don't
        if (maxWidth){
          count++;
          length = maxWidth + 1;
          while (length > maxWidth) {
            count--;  
            length = Font_StringWidth((void *) string, count, font, FONT_ASCII, FONT_DMA);
          }
        }
        
        dmachnl = DMAHR_GetNextFreeChannel();
    	if (dmachnl == DMAHR_NOCHNL) 
    	{
          return 2;  // Failed to draw range due to no free DMA ch.
    	}
        else {
          cfPrintwaitvar = 1;
        Font_Print(dmachnl, target,(void *)string , count, font, FONT_ASCII,
          FONT_FREERUN, FONT_HORIZONTAL, justify, cfPrintwait, xoffset,yoffset);
        while(cfPrintwaitvar) {;}
          return 0;
        }  
}